<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOneOrMany;

class Municipio extends Model
{
    use HasFactory;

    protected $fillable=['nome',  'codigo', 'latitude', 'longitude', 'precision','province_id', 'user_id', 'entidade_id'];

    // tem pode um responsável
    public function user():BelongsTo
    {
        return $this->BelongsTo(User::class);
    }

    //  
    public function users():HasOneOrMany
    {
        return $this->HasOneOrMany(User::class);
    }

    //  Tem vários parceiros
    public function parceiros():HasOneOrMany
    {
        return $this->HasOneOrMany(Parceiro::class);
    }
}
